<?php

namespace App\Http\Controllers;

use App\Models\{EmailList, Contact, Campaign, CampaignLog, EmailTemplate};

class DashboardController extends Controller
{
    public function index()
    {
        $stats = [
            'lists' => EmailList::count(),
            'contacts' => Contact::count(),
            'templates' => EmailTemplate::count(),
            'campaigns' => Campaign::count(),
            'opens' => CampaignLog::where('status', 'opened')->count(),
            'clicks' => CampaignLog::where('status', 'clicked')->count(),
        ];
        return view('dashboard', compact('stats'));
    }
}
