<?php

namespace App\Http\Controllers;

use App\Models\EmailList;
use Illuminate\Http\Request;

class EmailListController extends Controller
{
    public function index()
    {
        $lists = EmailList::latest()->paginate(10);
        return view('lists.index', compact('lists'));
    }

    public function create()
    {
        return view('lists.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate(['name' => 'required|string', 'description' => 'nullable|string']);
        EmailList::create($data);
        return redirect()->route('lists.index')->with('success', 'Email list created.');
    }

    public function edit(EmailList $list)
    {
        return view('lists.edit', compact('list'));
    }

    public function update(Request $request, EmailList $list)
    {
        $data = $request->validate(['name' => 'required|string', 'description' => 'nullable|string']);
        $list->update($data);
        return redirect()->route('lists.index')->with('success', 'List updated.');
    }

    public function destroy(EmailList $list)
    {
        $list->delete();
        return back()->with('success', 'List deleted.');
    }
}
