<?php

namespace App\Http\Controllers;

use App\Models\CampaignLog;
use Illuminate\Http\Request;

class TrackingController extends Controller
{
    public function open($campaignId, $contactId)
    {
        CampaignLog::where('campaign_id', $campaignId)
            ->where('contact_id', $contactId)
            ->update(['status' => 'opened']);

        // Return transparent pixel
        $pixel = base64_decode(
            'R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw=='
        );
        return response($pixel)->header('Content-Type', 'image/gif');
    }

    public function click(Request $request, $campaignId, $contactId)
    {
        $url = urldecode($request->query('url'));
        CampaignLog::where('campaign_id', $campaignId)
            ->where('contact_id', $contactId)
            ->update(['status' => 'clicked']);
        return redirect()->away($url);
    }
}
