<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class Campaign extends Model {
    protected $fillable = ['name','email_list_id','template_id','status','scheduled_at'];

    protected $dates = ['scheduled_at'];

    public function list() {
        return $this->belongsTo(EmailList::class,'email_list_id');
    }

    public function template() {
        return $this->belongsTo(EmailTemplate::class,'template_id');
    }

    public function logs() {
        return $this->hasMany(CampaignLog::class);
    }
}
