<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up() {
        Schema::create('contacts', function (Blueprint $table) {
            $table->id();
            $table->foreignId('email_list_id')->constrained('email_lists')->onDelete('cascade');
            $table->string('name')->nullable();
            $table->string('email')->index();
            $table->boolean('subscribed')->default(true);
            $table->timestamps();

            $table->unique(['email','email_list_id']);
        });
    }
    public function down() {
        Schema::dropIfExists('contacts');
    }
};
