<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up() {
        Schema::create('campaigns', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->foreignId('email_list_id')->constrained('email_lists')->onDelete('cascade');
            $table->foreignId('template_id')->constrained('email_templates')->onDelete('cascade');
            $table->enum('status', ['draft','scheduled','sending','sent','paused'])->default('draft');
            $table->timestamp('scheduled_at')->nullable();
            $table->timestamps();
        });
    }
    public function down() {
        Schema::dropIfExists('campaigns');
    }
};
