@extends('layouts.app')

@section('content')
<h1 class="text-2xl font-bold mb-4">Create Campaign</h1>
<form method="POST" action="{{ route('campaigns.store') }}" class="space-y-4">
    @csrf
    <div>
        <label class="block font-semibold">Name</label>
        <input name="name" class="border p-2 w-full rounded" required>
    </div>

    <div>
        <label class="block font-semibold">Email List</label>
        <select name="email_list_id" class="border p-2 w-full rounded" required>
            @foreach($lists as $list)
                <option value="{{ $list->id }}">{{ $list->name }}</option>
            @endforeach
        </select>
    </div>

    <div>
        <label class="block font-semibold">Template</label>
        <select name="template_id" class="border p-2 w-full rounded" required>
            @foreach($templates as $t)
                <option value="{{ $t->id }}">{{ $t->name }}</option>
            @endforeach
        </select>
    </div>

    <div>
        <label class="block font-semibold">Schedule (optional)</label>
        <input type="datetime-local" name="scheduled_at" class="border p-2 w-full rounded">
    </div>

    <button class="bg-blue-600 text-white px-4 py-2 rounded">Create</button>
</form>
@endsection
