@extends('layouts.app')

@section('content')
<div class="flex justify-between mb-4">
    <h1 class="text-2xl font-bold">Campaigns</h1>
    <a href="{{ route('campaigns.create') }}" class="bg-blue-600 text-white px-4 py-2 rounded">+ New Campaign</a>
</div>

<table class="w-full bg-white rounded shadow">
    <tr class="border-b">
        <th class="p-3">Name</th>
        <th class="p-3">List</th>
        <th class="p-3">Template</th>
        <th class="p-3">Status</th>
        <th class="p-3 text-right">Actions</th>
    </tr>
    @foreach($campaigns as $c)
    <tr class="border-b hover:bg-gray-50">
        <td class="p-3">{{ $c->name }}</td>
        <td class="p-3">{{ $c->list->name }}</td>
        <td class="p-3">{{ $c->template->name }}</td>
        <td class="p-3 capitalize">{{ $c->status }}</td>
        <td class="p-3 text-right space-x-2">
            <form action="{{ route('campaigns.destroy', $c) }}" method="POST" class="inline">
                @csrf @method('DELETE')
                <button class="text-red-500">Delete</button>
            </form>
            @if($c->status == 'draft')
            <a href="{{ route('campaigns.send', $c) }}" class="text-blue-600">Send Now</a>
            @endif
        </td>
    </tr>
    @endforeach
</table>
@endsection
