@extends('layouts.app')

@section('content')
<h1 class="text-2xl font-bold mb-4">Contacts – {{ $list->name }}</h1>

<form action="{{ route('lists.contacts.import', $list) }}" method="POST" enctype="multipart/form-data" class="mb-6">
    @csrf
    <label class="block mb-2 font-semibold">Upload CSV</label>
    <input type="file" name="file" class="border p-2 w-full rounded mb-3" required>
    <button class="bg-blue-600 text-white px-4 py-2 rounded">Import</button>
</form>

<table class="w-full bg-white rounded shadow">
    <tr class="border-b">
        <th class="p-3 text-left">Email</th>
        <th class="p-3 text-left">Name</th>
        <th class="p-3 text-left">Created</th>
    </tr>
    @foreach($contacts as $c)
        <tr class="border-b hover:bg-gray-50">
            <td class="p-3">{{ $c->email }}</td>
            <td class="p-3">{{ $c->name }}</td>
            <td class="p-3">{{ $c->created_at->diffForHumans() }}</td>
        </tr>
    @endforeach
</table>
@endsection
