<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ config('app.name') }}</title>
    @vite('resources/css/app.css')
</head>
<body class="bg-gray-100 text-gray-900">
    <nav class="bg-white shadow p-4 flex justify-between">
        <a href="{{ route('campaigns.index') }}" class="font-bold text-xl text-blue-600">Mailer</a>
        <div class="space-x-4">
            <a href="{{ route('lists.index') }}">Lists</a>
            <a href="{{ route('templates.index') }}">Templates</a>
            <a href="{{ route('campaigns.index') }}">Campaigns</a>
            <form method="POST" action="{{ route('logout') }}" class="inline">
                @csrf
                <button type="submit" class="text-red-500">Logout</button>
            </form>
        </div>
    </nav>

    <main class="p-6 max-w-5xl mx-auto">
        @if(session('success'))
            <div class="bg-green-100 border border-green-300 text-green-800 px-4 py-2 rounded mb-4">
                {{ session('success') }}
            </div>
        @endif
        {{ $slot ?? '' }}
        @yield('content')
    </main>
</body>
</html>
