@extends('layouts.app')

@section('content')
<div class="flex justify-between mb-4">
    <h1 class="text-2xl font-bold">Email Lists</h1>
    <a href="{{ route('lists.create') }}" class="bg-blue-600 text-white px-4 py-2 rounded">+ New List</a>
</div>

<table class="w-full bg-white rounded shadow">
    <tr class="border-b">
        <th class="p-3 text-left">Name</th>
        <th class="p-3 text-left">Description</th>
        <th class="p-3 text-right">Actions</th>
    </tr>
    @foreach($lists as $list)
        <tr class="border-b hover:bg-gray-50">
            <td class="p-3">{{ $list->name }}</td>
            <td class="p-3">{{ $list->description }}</td>
            <td class="p-3 text-right space-x-2">
                <a href="{{ route('lists.edit', $list) }}" class="text-blue-600">Edit</a>
                <form method="POST" action="{{ route('lists.destroy', $list) }}" class="inline">
                    @csrf @method('DELETE')
                    <button class="text-red-500">Delete</button>
                </form>
            </td>
        </tr>
    @endforeach
</table>
@endsection
