@extends('layouts.app')

@section('content')
<div class="flex justify-between mb-4">
    <h1 class="text-2xl font-bold">Email Templates</h1>
    <a href="{{ route('templates.create') }}" class="bg-blue-600 text-white px-4 py-2 rounded">+ New Template</a>
</div>

<table class="w-full bg-white rounded shadow">
    <tr class="border-b">
        <th class="p-3 text-left">Name</th>
        <th class="p-3 text-left">Subject</th>
        <th class="p-3 text-right">Actions</th>
    </tr>
    @foreach($templates as $t)
    <tr class="border-b hover:bg-gray-50">
        <td class="p-3">{{ $t->name }}</td>
        <td class="p-3">{{ $t->subject }}</td>
        <td class="p-3 text-right space-x-2">
            <a href="{{ route('templates.edit', $t) }}" class="text-blue-600">Edit</a>
            <form method="POST" action="{{ route('templates.destroy', $t) }}" class="inline">
                @csrf @method('DELETE')
                <button class="text-red-500">Delete</button>
            </form>
        </td>
    </tr>
    @endforeach
</table>
@endsection
