<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\{
    ProfileController,
    EmailListController,
    ContactController,
    TemplateController,
    CampaignController,
    TrackingController,
    DashboardController
};

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
*/

// 👇 Redirect root to campaigns
Route::get('/', function () {
    return redirect()->route('campaigns.index');
});

// 👇 Authenticated routes
Route::middleware(['auth', 'verified'])->group(function () {

    // Profile
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    // Email Management
    Route::resource('lists', EmailListController::class);
    Route::resource('lists.contacts', ContactController::class)->shallow();
    Route::resource('templates', TemplateController::class);
    Route::resource('campaigns', CampaignController::class);

    // Dashboard
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
});

// 👇 Tracking routes (public, no auth)
Route::get('/track/open/{campaign}/{contact}', [TrackingController::class, 'open']);
Route::get('/track/click/{campaign}/{contact}', [TrackingController::class, 'click']);

// 👇 Auth routes
require __DIR__.'/auth.php';
